<?php 

ini_set('display_errors', 1);ini_set('display_startup_errors', 1);error_reporting(E_ALL);//Activa ver warnings

require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Reader\Csv;
use PhpOffice\PhpSpreadsheet\Reader\Xls;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpWord\Shared\Converter;
use PhpOffice\PhpWord\TemplateProcessor;
use PhpOffice\PhpWord\Element\Table;

//echo 'Versión actual de PHP: ' . phpversion();echo "<br>";
//require 'functions.php';//Aqui es donde realmente esta el template y las equivalencias

//La data que se va a meter al template... se divide en 3 que son llaves normales, tablas e imagenes

//valores simples por sustituir en el template
$data = array(
    'TONAME' => "Whoever name",
    'TOEMAIL' => "alexcd2000@yopmail.com",
    'FROMNAME' => "Whoever else name",
    'ID' => "88789581",
    'CSD' => "1123",
    'TIMESTAMP' => "14-11-2022 19:23"
);
//rows de tablas, el estilo y si tienes mas o menos columnas lo editas en la funcion. 
//Igual si tienes filas con rowspan 2 las pones alla en la funcion
$tabla = array(
    array(
        'name' => "Producto 12893",
        'cant'  => 4,
        'import'  => 100
    ),
    array(
        'name' => "Producto 2",
        'cant'  => 10,
        'import'  => 100
    )
);
//ruta a todas las imagenes a sustituir
$imagenes = array(
    array(
        'name' => "photo1",
        'path' => __DIR__."/img/photo1.png"
    ),
    array(
        'name' => "photo2",
        'path' => __DIR__."/img/photo2.png"
    ),
    array(
        'name' => "photo3",
        'path' => __DIR__."/img/photo3.jpg"
    )
);

$datos = array(
    'data' => $data,
    'tabla' => $tabla,
    'imagenes' => $imagenes
);

echo generateWordDocument($datos,'template_sample3.docx',"output/"); //regresa la dirección donde se guardo

function generateWordDocument($datos,$template,$outFolder){

    $docxPath = $template;
    $template = new \PhpOffice\PhpWord\TemplateProcessor($docxPath);
    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    
    //agrega los valores del array, la key debe ser igual a lo que esta en ${} en el template
    if(isset($datos['data'])){
        $i=0; foreach( $datos['data'] as $key=>$feach){
            $template->setValue($key, $feach);
        $i++;
        }
    }

    if(isset($datos['tabla'])){
        $section = $phpWord->addSection();
        //Las propiedades y estilos las ves aqui
        //https://phpword.readthedocs.io/en/latest/styles.html#table
        
        $tableCellStyle = ['valign' => 'center', 'borderBottomColor'=>"red",'borderBottomSize'=>"1"];//para las celdas
        $tableStyleCellRowSpan = ['gridSpan' => 2,  'valign' => 'center', 'bgColor' => 'f0f0f0'];//para tener celdas con rowspan mergged
        
        $paragraphStyle=['align'=>'center']; //para centrar el texto es una propiedad del parrafo, es el segundo parameetro
        $tableFontStyle = ['bold' => true];// para las fuentes
        

        $table = $section->addTable('Table');
        $table->addRow();
        $table->addCell(2000, $tableCellStyle)->addText('Cantidad', $tableFontStyle, $paragraphStyle);
        $table->addCell(5000, $tableCellStyle)->addText('Producto', $tableFontStyle);
        $table->addCell(2000, $tableCellStyle)->addText('Monto', $tableFontStyle);
        
        foreach ($datos['tabla'] as $row) {
            $table->addRow();
            //esto vas a tener que escribirlo segun el número de columnas en tu archivo
            $table->addCell(2000)->addText($row['cant']);
            $table->addCell(5000)->addText($row['name']);
            $table->addCell(2000)->addText($row['import']);
        }

        //celdas merged vas a tener que ponerlas directo en la funcion...
        $table->addRow();
        $table->addCell(2000, $tableStyleCellRowSpan)->addText("Total de total");
        $table->addCell(2000, $tableCellStyle)->addText("12654");

        $template->setComplexBlock('TABLEPRODUCTS', $table);
    }

    if(isset($datos['imagenes'])){
        //Las imagenes en el template se deben llamar siempre ${IMAGEN#}
        foreach ($datos['imagenes'] as $i => $row) {
            $template->setImageValue(sprintf('IMAGEN#%d', $i + 1), $row['path']);
        }
    }

    //La carpeta donde se guarda debe de tener permisos 777 para guardar segun el servidor
    $output = $outFolder.time().$docxPath;//el nombre y ruta donde se va a guardar
    $template->saveAs($output); 

    return $output;
}




?>