<?php
require_once "./config.php";
?>
<!DOCTYPE html>
<html lang="en">
<?php require_once "./head.php"; ?>

<body>
    <?php require_once "./header.php"; ?>

    <!-- Main content -->
    <div class="content">
        <!-- Page header -->
        <div class="page-header">
            <h1 class="page-title"><?php echo $pageTitle; ?></h1>
            <div class="botonera">
                <button class="success" id="addBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="5" x2="12" y2="19"></line>
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    Add User
                </button>
                <!-- <button id="importCsvBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="17 8 12 3 7 8"></polyline>
                        <line x1="12" y1="3" x2="12" y2="15"></line>
                    </svg>
                    Import from CSV
                </button>-->
                <button id="exportCsvBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="7 10 12 15 17 10"></polyline>
                        <line x1="12" y1="15" x2="12" y2="3"></line>
                    </svg>
                    Export to CSV
                </button> 
            </div>
        </div>

        <!-- Table container -->
        <?php
        $filter = "WHERE ";
        if (isset($_GET['filter_status']) and $_GET['filter_status'] != "") {
            $filter .= "status = '" . $_GET['filter_status'] . "' ";
        }
        if (isset($_GET['filter_type']) and $_GET['filter_type'] != "") { 
            if ($filter != 'WHERE ') {
                $filter .= "AND ";
            }
            $filter .= "type = '" . $_GET['filter_type'] . "' ";
        }
        if ($filter == 'WHERE ') {
            $filter = "";
        }

        generarTabla("SELECT id,created,updated,email,pwd as pwd,name,status,type FROM users " . $filter . " ORDER BY id ASC", array("Status" => "SELECT DISTINCT(status) FROM users;", "Types" => "SELECT DISTINCT(type) FROM users;")); ?>
    </div>

    <div id="popup-add" class="popup">
        <h3 style="text-align:center;">Create New User</h3>
        <label>User (email):</label>
        <input type="email" id="add-user" class="form-control" style="width:100%; margin-bottom:10px;">

        <label>Password:</label>
        <input type="text" id="add-pwd" class="form-control" style="width:100%; margin-bottom:10px;">

        <label>Name:</label>
        <input type="text" id="add-name" class="form-control" style="width:100%; margin-bottom:10px;">

        <label>Status:</label>
        <select id="add-status" class="form-control" style="width:100%; margin-bottom:10px;">
            <option value="active">Active</option>
            <option value="paused">Paused</option>
        </select>

        <label>Type:</label>
        <select id="add-type" class="form-control" style="width:100%; margin-bottom:15px;">
            <option value="admin">Admin</option>
            <option value="office">Office</option>
        </select>

        <div style="display:flex; justify-content:space-between;">
            <button id="btn-save-add">Save</button>
            <button id="btn-cancel-add">Cancel</button>
        </div>
    </div>

    <div id="popup-edit" class="popup">
        <h3 style="text-align:center;">Edit User</h3>
        <label>User (email):</label>
        <input type="email" id="edit-user" class="form-control" style="width:100%; margin-bottom:10px;">

        <label>Password:</label>
        <input type="text" id="edit-pwd" class="form-control" style="width:100%; margin-bottom:10px;">

        <label>Name:</label>
        <input type="text" id="edit-name" class="form-control" style="width:100%; margin-bottom:10px;">

        <label>Status:</label>
        <select id="edit-status" class="form-control" style="width:100%; margin-bottom:10px;">
            <option value="active">Active</option>
            <option value="paused">Paused</option>
        </select>

        <label>Type:</label>
        <select id="edit-type" class="form-control" style="width:100%; margin-bottom:15px;">
            <option value="admin">Admin</option>
            <option value="office">Office</option>
        </select>

        <div style="display:flex; justify-content:space-between;">
            <button id="btn-save-edit">Save</button>
            <button id="btn-cancel-edit">Cancel</button>
        </div>
    </div>

    <div id="overlay" class="overlay"></div>

    <script>
        jQuery(document).ready(function($) {
            // Crear nuevo
            $("#addBtn").on("click", function() {
                $("#popup-add, #overlay").fadeIn(200);
            });
            $("#btn-cancel-add").on("click", function() {
                $("#popup-add, #overlay").fadeOut(200);
            });
            $("#btn-save-add").on("click", function() {
                const uri = window.location.pathname;
                const user = $("#add-user").val();
                const pwd = $("#add-pwd").val();
                const name = $("#add-name").val();
                const status = $("#add-status").val();
                const type = $("#add-type").val();

                if (!user || !pwd || !name) {
                    alert("Please fill all fields");
                    return;
                }

                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'create_user',
                        uri: uri,
                        user: user,
                        pwd: pwd,
                        name: name,
                        status: status,
                        type: type
                    },
                    success: function(response) {
                        alert("User created successfully");
                        location.reload(); // ← refresca la página
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.error("AJAX error:", textStatus, errorThrown);
                        alert("Failed to create record.");
                    }
                });
            });

            // Editar
            window.editRecord = function(id) {
                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'get_user',
                        id: id,
                    },
                    success: function(response) {
                        try {
                            const user = JSON.parse(response);

                            $("#edit-user").val(user.email); // usa email, no user
                            $("#edit-pwd").val(user.pwd);
                            $("#edit-name").val(user.name);
                            $("#edit-status").val(user.status);
                            $("#edit-type").val(user.type);
                            $("#popup-edit").data("user-id", user.id);

                            $("#popup-edit, #overlay").fadeIn(200);
                        } catch (e) {
                            alert("Error parsing user data.");
                            console.error(e);
                        }
                    },
                    error: function() {
                        alert("Failed to fetch user data.");
                    }
                });
            }
            $("#btn-cancel-edit").on("click", () => $("#popup-edit").fadeOut(200));
            $("#btn-save-edit").on("click", function() {
                const userId = $("#popup-edit").data("user-id");

                const user = $("#edit-user").val();
                const pwd = $("#edit-pwd").val();
                const name = $("#edit-name").val();
                const status = $("#edit-status").val();
                const type = $("#edit-type").val();

                if (!user || !pwd || !name) {
                    alert("Please fill all fields");
                    return;
                }

                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'edit_user',
                        id: userId,
                        user: user,
                        pwd: pwd,
                        name: name,
                        status: status,
                        type: type
                    },
                    success: function(response) {
                        console.log(response);
                        try {
                            const updated = JSON.parse(response).data;

                            // Actualizar visualmente la fila, tiene que hacer match el query de generarTabla con los nombres regresa el ajax de los campos de la bdd
                            const row = $(`tr[fila="${updated.id}"]`);
                            row.find("td[col]").each(function () {
                                const campo = $(this).attr("col");
                                if (updated[campo] !== undefined) {
                                    $(this).text(updated[campo]);
                                }
                            });
                            
                            var tabla = $('#tabla-dinamica').DataTable();
                            tabla.row(row).invalidate().draw(); // ← fuerza a redibujar la fila correctamente

                            $("#popup-edit").fadeOut(200);
                        } catch (e) {
                            alert("Saved but failed to parse response");
                            console.log(e);
                        }
                    },
                    error: function() {
                        alert("Failed to update user.");
                    }
                });
            });

            // Borrar
            window.deleteRecord = function(id) {
                if (!confirm("Are you sure you want to delete the record with id=" + id + "?")) return;

                const uri = window.location.pathname;
                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'delete_user',
                        id: id,
                        uri: uri
                    },
                    success: function(response) {
                        const row = $(`tr[fila="${id}"]`);
                        var tabla = $('#tabla-dinamica').DataTable(); // ← recuperas instancia ya inicializada
                        tabla.row(row).remove().draw();
                        alert("Record deleted successfully.");
                        $("#resultsquery").html($("#resultsquery").html()-1);
                        //alert("Response: " + response);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.error("AJAX error:", textStatus, errorThrown);
                        alert("Failed to delete record, contact support");
                    }
                });
            }

            // Exportar
            $("#exportCsvBtn").on("click", function() {
                $.ajax({
                    url: './ajax.php',
                    method: 'POST',
                    data: {
                        action: 'export_users_csv'
                    },
                    success: function(data, status, xhr) {
                        // Crear archivo y forzar descarga
                        const filename = 'users_export_' + new Date().toISOString().slice(0, 19).replace(/[:T]/g, '-') + '.csv';
                        const blob = new Blob([data], {
                            type: 'text/csv;charset=utf-8;'
                        });

                        const link = document.createElement('a');
                        link.href = URL.createObjectURL(blob);
                        link.download = filename;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    },
                    error: function() {
                        alert("Failed to export CSV.");
                    }
                });
            });
        });
    </script>
    
    <?php require_once "./footer.php"; ?>
    <?php if (isset($alert)) {
        echo '<script>alert(" ' . $alert . ' ")</script>';
    } ?>
</body>

</html>