<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <link rel="icon" href="/assets/favicon.png">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .auth.login-bg {
            background: url("/assets/loginbg.jpg") no-repeat center center fixed !important;
            background-size: cover !important;
            width: 100%;
            height: 100vh;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: Arial, sans-serif;
        }

        .login-box {
            background: rgba(255, 255, 255, 0.9);
            padding: 30px 40px;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.3);
            width: 100%;
            max-width: 400px;
        }

        .login-box h2 {
            margin-bottom: 20px;
            text-align: center;
            color: #333;
        }

        .login-box input[type="email"],
        .login-box input[type="password"] {
            width: 100%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        .login-box button {
            width: 100%;
            padding: 12px;
            background-color: #004225;
            color: white;
            border: none;
            border-radius: 4px;
            font-weight: bold;
            cursor: pointer;
        }

        .login-box button:hover {
            background-color: #00663e;
        }

        .login-box .forgot-link {
            display: block;
            margin-top: 15px;
            text-align: center;
            font-size: 14px;
        }

        .login-box .forgot-link a {
            color: #004225;
            text-decoration: none;
            font-weight: bold;
        }

        .login-box .forgot-link a:hover {
            text-decoration: underline;
        }

        .alert {
            color: red;
            font-size: 14px;
            margin-top: 10px;
            text-align: center;
        }

    </style>
</head>

<body>
    <div class="auth login-bg">
        <form class="login-box" method="POST" action="login.php">
            <h2>Request your password sent to your email</h2>
            <input type="email" name="email-reset" placeholder="Email" required>
            <button type="submit">Submit</button>
            <div class="forgot-link">
                <a href="login.php">Go back to login page</a>
            </div>
        </form>
    </div>
</body>

</html>
