<?php
// GSheets/config.php
// Creates a Google client and exposes $service (Sheets) + alias $sheetsService.

require __DIR__ . "/vendor/autoload.php";

$client = new Google_Client();
// Small label only (optional)
$client->setApplicationName("Mi App - Google APIs");

// Scopes for Sheets (read/write)
$client->setScopes([
    Google_Service_Sheets::SPREADSHEETS
]);

// Service account credentials
$client->setAuthConfig(__DIR__ . "/credentials.json");

// IMPORTANT: ejemplo.php expects $service
$service = new Google_Service_Sheets($client);

// Alias (in case you prefer this name in other scripts)
$sheetsService = $service;
?>