<?php
/**
 * Plugin Name: Wiloke 3D Parallax
 * Plugin URI: https://plugins.wiloke.com/3d-parallax
 * Description: Add stunning 3D parallax effects to your WordPress site with ease. Wiloke 3D Parallax enhances your site's visual experience with smooth, responsive, and customizable 3D animations.
 * Author: Wiloke
 * Author URI: https://plugins.wiloke.com
 * Version: 1.0.0
 * Text Domain: wiloke-3d-parallax
 */

define("WILOKE_3D_PARALLAX_VERSION", "1.0.3");
define("WILOKE_3D_PARALLAX_ID", "wil-3d-parallax");
define("WILOKE_3D_PARALLAX_SOURCE_URL", plugin_dir_url(__FILE__) . "src/Source/");
define("WILOKE_3D_PARALLAX_WIDGET_PATH", plugin_dir_path(__FILE__) . "src/Widgets/");

add_action("plugins_loaded", "wiloke3DParallaxLanguage");

if (!function_exists("wiloke3DParallaxLanguage")) {
	function wiloke3DParallaxLanguage()
	{
		load_plugin_textdomain("wiloke-3d-parallax", false, plugin_dir_path(__FILE__) . "languages");
	}
}

require_once plugin_dir_path(__FILE__) . "vendor/autoload.php";

new \Wiloke3DParallax\Widgets\RegistrationController();
