<?php

namespace Wiloke3DParallax\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class Wiloke3DParallax3DScroll extends Widget_Base
{
	public function get_script_depends()
	{
		return [WILOKE_3D_PARALLAX_ID . '-3d-scroll'];
	}

	public function get_style_depends()
	{
		return [WILOKE_3D_PARALLAX_ID . '-3d-scroll'];
	}

	public function get_name()
	{
		return 'wiloke-3d-scroll';
	}

	public function get_title()
	{
		return esc_html__('Wiloke 3D Parallax Scroll', 'wiloke-3d-parallax');
	}

	public function get_icon()
	{
		// Use an appropriate icon for this widget
		return 'eicon-slider-3d';
	}

	protected function _register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Content', 'wiloke-3d-parallax'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label'   => esc_html__('Style', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'style1' => esc_html__('Style 1', 'wiloke-3d-parallax'),
					'style2' => esc_html__('Style 2', 'wiloke-3d-parallax')
				],
				'default' => 'style1'
			]
		);

		// Title
		$this->add_control(
			'title',
			[
				'label'   => esc_html__('Title', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Title', 'wiloke-3d-parallax'),
			]
		);

		// Title Tag
		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Title Tag', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h3',
			]
		);

		// Description
		$this->add_control(
			'description',
			[
				'label'   => esc_html__('Description', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Description', 'wiloke-3d-parallax'),
			]
		);

		// Button Name
		$this->add_control(
			'button_text',
			[
				'label'   => esc_html__('Button Name', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Click Here', 'wiloke-3d-parallax'),
			]
		);

		// Button Link
		$this->add_control(
			'button_link',
			[
				'label'         => esc_html__('Button Link', 'wiloke-3d-parallax'),
				'type'          => Controls_Manager::URL,
				'placeholder'   => 'https://your-link.com',
				'show_external' => true,
				'default'       => [
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				],
			]
		);

		// Button Icon
		$this->add_control(
			'button_icon',
			[
				'label' => esc_html__('Button Icon', 'wiloke-3d-parallax'),
				'type'  => Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => esc_html__('Background Color', 'wiloke-3d-parallax'),
				'type'  => Controls_Manager::COLOR,
			]
		);

		// Images
		for ($i = 1; $i <= 3; $i++) {
			$this->add_control(
				"image_$i",
				[
					'label'   => esc_html__('Image ' . $i, 'wiloke-3d-parallax'),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
				]
			);
		}

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$style = $settings['style'];
		if ($style === 'style1') {
			include WILOKE_3D_PARALLAX_WIDGET_PATH . 'Partials/3d-scroll-style1.php';
		} else {
			include WILOKE_3D_PARALLAX_WIDGET_PATH . 'Partials/3d-scroll-style2.php';
		}
	}
}
