<?php

namespace Wiloke3DParallax\Widgets;

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;

class Wiloke3DParallax3DHover extends Widget_Base
{

	public function get_name()
	{
		return 'wiloke-3d-parallax-3d-hover';
	}

	public function get_title()
	{
		return esc_html__('Wiloke 3D Parallax Hover', 'wiloke-3d-parallax');
	}

	public function get_icon()
	{
		// Replace with an appropriate Elementor icon
		return 'eicon-image-rollover';
	}

	public function get_script_depends()
	{
		return [WILOKE_3D_PARALLAX_ID . '-3d-hover'];
	}

	public function get_style_depends()
	{
		return [WILOKE_3D_PARALLAX_ID . '-3d-hover'];
	}

	protected function _register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Content', 'wiloke-3d-parallax'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'   => esc_html__('Title', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Title', 'wiloke-3d-parallax'),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Heading Tag', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h3',
			]
		);

		$this->add_control(
			'description',
			[
				'label'   => esc_html__('Description', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::WYSIWYG,
				'default' => esc_html__('Description', 'wiloke-3d-parallax'),
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'   => esc_html__('Button Text', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Click Here', 'wiloke-3d-parallax'),
			]
		);

		$this->add_control(
			'button_icon',
			[
				'label' => esc_html__('Button Icon', 'wiloke-3d-parallax'),
				'type'  => Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'button_url',
			[
				'label'         => esc_html__('Button URL', 'wiloke-3d-parallax'),
				'type'          => Controls_Manager::URL,
				'placeholder'   => 'https://your-link.com',
				'show_external' => true,
				'default'       => [
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label'   => esc_html__('Choose Image', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => esc_html__('Background Color', 'wiloke-3d-parallax'),
				'type'  => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'v_strength_attribute',
			[
				'label'   => esc_html__('Strength Attribute', 'wiloke-3d-parallax'),
				'type'    => Controls_Manager::NUMBER,
				'default' => 80,
			]
		);

		$this->end_controls_section();
	}


	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$heading = $settings['title'];
		$headingTag = $settings['title_tag'];
		$description = $settings['description'];
		$buttonText = $settings['button_text'];
		$buttonIcon = $settings['button_icon'];
		$iconValue = !empty($buttonIcon['value']) ? $buttonIcon['value'] : '';
		$buttonUrl = $settings['button_url']['url'];
		$buttonTarget = !empty($settings['button_url']['is_external']) ? '_blank' : '_self';
		$image = $settings['image'];
		$backgroundColor = $settings['background_color'];
		$vStrengthAttribute = $settings['v_strength_attribute'];

		?>
		<v-parallax>
			<div style="position: relative">
				<v-parallax-hover v-3d="" v-strength="<?php echo esc_attr($vStrengthAttribute); ?>">
					<div
						class="veda-parallax-hover-bg"
						style="border-radius: 10px;background-color: <?php echo esc_attr($backgroundColor); ?>;"
					></div>
					<div class="veda-parallax-hover-image">
						<?php if (empty($image["id"])): ?>
							<img src="<?php echo esc_url($image["url"]); ?>" alt="<?php echo esc_attr($heading); ?>" loading="lazy">
						<?php else: ?>
							<?php echo wp_get_attachment_image($image['id'], 'large'); ?>
						<?php endif; ?>
					</div>
				</v-parallax-hover>
				<div>
					<<?php echo esc_attr($headingTag); ?> class="veda-parallax-hover-title"><?php echo esc_html($heading);
					?></<?php echo esc_attr($headingTag); ?>>
					<div><?php echo wp_kses_post($description); ?></div>
					<?php if (!empty($buttonUrl)) : ?>
					<a class="veda-parallax-hover-button" href="<?php echo esc_url($buttonUrl); ?>" target="<?php echo esc_attr($buttonTarget); ?>">
						<span><?php echo esc_html($buttonText); ?></span>
						<?php if (!empty($iconValue)): ?>
							<span><i class="<?php echo esc_attr($iconValue); ?>"></i></span>
						<?php endif; ?>
					</a>
					<?php endif; ?>
				</div>
			</div>
		</v-parallax>
		<?php
	}
}

