<?php

namespace Wiloke3DParallax\Widgets;

class RegistrationController
{
	public function __construct()
	{
		add_action('elementor/widgets/widgets_registered', [$this, 'registerWidgets']);
		add_action('wp_enqueue_scripts', [$this, 'registerScripts']);
		add_action('wp_enqueue_scripts', [$this, 'registerStyles']);
	}

	public function registerWidgets($oWidgetManager)
	{
		// Assuming you have already included the Wiloke3DParallax3DHover widget class
		$oWidgetManager->register_widget_type(new Wiloke3DParallax3DHover());
		$oWidgetManager->register_widget_type(new Wiloke3DParallax3DScroll());
	}

	public function registerScripts()
	{
		// Register your scripts here
		wp_register_script(
			WILOKE_3D_PARALLAX_ID . '-3d-hover',
			WILOKE_3D_PARALLAX_SOURCE_URL . 'script-3d-hover.js',
			[],
			WILOKE_3D_PARALLAX_VERSION,
			true
		);

		wp_register_script(
			WILOKE_3D_PARALLAX_ID . '-3d-scroll',
			WILOKE_3D_PARALLAX_SOURCE_URL . 'script-3d-scroll.js',
			[],
			WILOKE_3D_PARALLAX_VERSION,
			true
		);
	}

	public function registerStyles()
	{
		// Register your styles here
		wp_register_style(
			WILOKE_3D_PARALLAX_ID . '-3d-hover',
			WILOKE_3D_PARALLAX_SOURCE_URL . 'style-3d-hover.css',
			[],
			WILOKE_3D_PARALLAX_VERSION,
			'all'
		);

		wp_register_style(
			WILOKE_3D_PARALLAX_ID . '-3d-scroll',
			WILOKE_3D_PARALLAX_SOURCE_URL . 'style-3d-scroll.css',
			[],
			WILOKE_3D_PARALLAX_VERSION,
			'all'
		);
	}
}
