<?php
$settings = $this->get_settings_for_display();
$heading = $settings['title'];
$headingTag = $settings['title_tag'];
$description = $settings['description'];
$buttonText = $settings['button_text'];
$buttonIcon = $settings['button_icon'];
$iconValue = !empty($buttonIcon['value']) ? $buttonIcon['value'] : '';
$buttonUrl = $settings['button_link']['url'];
$buttonTarget = !empty($settings['button_link']['is_external']) ? '_blank' : '_self';
$image1 = $settings['image_1'];
$image2 = $settings['image_2'];
$image3 = $settings['image_3'];
$backgroundColor = $settings['background_color'];
?>
<v-parallax>
	<div class="container pos:relative z:1 p:pfs(20px,40px)">
		<div class="pos:absolute t:0 l:0 z:-1 w:100% h:100%">
			<v-parallax-scroll
				v-keyframes="{ '10%': { scale: 0 }, '40%': { scale: 1 } }"
				class="w:100% h:100%"
				style="transform: scale(1)"
			>
				<div
					style="opacity: 0.1"
					class="w:100% h:100% bgc:color-primary bdrs:20px"
				></div>
			</v-parallax-scroll>
		</div>
		<div
			class="row ai:center fld:column@+sm"
			style="margin-top: -80px; margin-left: -40px; margin-right: -40px"
		>
			<div
				class="col w:100%@+sm! flx:auto! pos:relative"
				style="
                width: 50%;
                margin-top: 80px;
                padding-left: 40px;
                padding-right: 40px;
              "
			>
				<div>
					<?php if ($image1['id']): ?>
						<v-parallax-scroll
							v-keyframes="{ '10%': { y: 100 }, '90%': { y: -100 } }"
							class="pos:relative z:2 w:100% maw:460px m:auto"
							style="transform: translateY(4.5536px)"
						>
							<div class="w:100% pt:100%"></div>
							<div
								class="pos:absolute t:0 l:0 w:100% h:100% ov:hidden d:flex ai:center jc:center"
							>
								<?php echo wp_get_attachment_image($image1['id'], 'large', false, [
									"class" => "w:100% h:100% obf:cover obf:contain! w:100% h:100%"
								]); ?>
							</div>
						</v-parallax-scroll>
					<?php endif; ?>
					<?php if ($image2['id']): ?>
						<v-parallax-scroll
							v-keyframes="{ '10%': { y: 100 }, '90%': { y: -300 } }"
							class="pos:absolute l:pfs(-20px,-100px) t:pfs(-20px,-80px) z:3 w:100% maw:pfs(150px,250px) m:auto pe:none"
							style="transform: translateY(-90.8928px)"
						>
							<div class="w:100% pt:100%"></div>
							<div
								class="pos:absolute t:0 l:0 w:100% h:100% ov:hidden d:flex ai:center jc:center"
							>
								<?php echo wp_get_attachment_image($image2['id'], 'large', false, [
									"class" => "w:100% h:100% obf:cover obf:contain! w:100% h:100%"
								]); ?>
							</div>
						</v-parallax-scroll>
					<?php endif; ?>
				</div>
			</div>
			<div
				class="col w:100%@+sm! flx:auto"
				style="
                width: 50%;
                margin-top: 80px;
                padding-left: 40px;
                padding-right: 40px;
              "
			>
				<div
					class="group* pos:relative ta:left@+sm!"
					style="border-radius: 0px; text-align: left"
				>
					<<?php echo esc_attr($headingTag); ?> class="c:color-gray9 fz:pfs(40px,80px)
					mb:0"><?php echo esc_html($heading); ?></<?php echo esc_attr($headingTag); ?>>
				<div class="fz:16px mt:20px">
					<p>
						<?php echo wp_kses_post($description); ?>
					</p>
				</div>
				<?php if (!empty($buttonUrl)) : ?>
					<a
						class="rs d:inline-block td:none lh:1.5 fz:15px ff:font-primary fw:500 trs:0.3s p:13px_20px bd:none bxsh:none o:none cur:pointer bgc:color-primary c:color-light bgc:color-gray9|h c:color-light|h bdrs:4px mt:40px"
						href="<?php echo esc_url($buttonUrl) ?>"
						target="<?php echo esc_attr($buttonTarget); ?>"
					>
						<span><?php echo esc_html($buttonText); ?></span>
						<?php if (!empty($iconValue)): ?>
							<span class="ml:10px" data-css="">
            <i class="<?php echo esc_attr($iconValue); ?>"></i>
          </span>
						<?php endif; ?>
					</a>
				<?php endif; ?>

				<?php if (!empty($image3)) : ?>
					<v-parallax-scroll
						v-keyframes="{ '10%': { y: 100 }, '90%': { y: -100 } }"
						class="pos:absolute r:pfs(-50px,-100px) b:pfs(-20px,-180px) z:1 w:100% maw:pfs(100px,300px) m:auto pe:none"
						style="transform: translateY(4.5536px)"
					>
						<div class="w:100% pt:100%"></div>
						<div
							class="pos:absolute t:0 l:0 w:100% h:100% ov:hidden d:flex ai:center jc:center"
						>
							<?php echo wp_get_attachment_image($image3['id'], 'large', false, [
								"class" => "w:100% h:100% obf:cover obf:contain! w:100% h:100%"
							]); ?>
						</div>
					</v-parallax-scroll>
				<?php endif; ?>
			</div>
		</div>
	</div>
	</div>
</v-parallax>
