<?php

$heading = $settings['title'];
$headingTag = $settings['title_tag'];
$description = $settings['description'];
$buttonText = $settings['button_text'];
$buttonIcon = $settings['button_icon'];
$iconValue = !empty($buttonIcon['value']) ? $buttonIcon['value'] : '';
$buttonUrl = $settings['button_link']['url'];
$buttonTarget = !empty($settings['button_link']['is_external']) ? '_blank' : '_self';
$image1 = $settings['image_1'];
$image2 = $settings['image_2'];
$image3 = $settings['image_3'];
$backgroundColor = $settings['background_color'];

?>
<v-parallax>
	<div class="container veda-container">
		<div
			class="row ai:center fld:column@+sm"
			style="margin-top: -80px; margin-left: -40px; margin-right: -40px"
		>
			<div
				class="col w:100%@+sm! flx:auto!"
				style="
                width: 50%;
                margin-top: 80px;
                padding-left: 40px;
                padding-right: 40px;
              "
			>
				<div class="pos:relative">
					<?php if (!empty($image1)) : ?>

						<v-parallax-scroll
							v-keyframes="{ '10%': { y: 200 }, '90%': { y: -200 } }"
							class="pos:relative z:2 w:100% maw:460px m:auto"
							style="transform: translateY(-90.5363px)"
						>
							<div class="w:100% pt:100%"></div>
							<div
								class="pos:absolute t:0 l:0 w:100% h:100% ov:hidden d:flex ai:center jc:center pe:none"
							>
								<?php echo wp_get_attachment_image($image1['id'], 'large', false, [
									"class" => "w:100% h:100% obf:cover obf:contain! w:100% h:100%"
								]); ?>
							</div>
						</v-parallax-scroll>
					<?php endif; ?>

					<?php if (!empty($image2)) : ?>
						<v-parallax-scroll
							v-keyframes="{ '10%': { y: 300 }, '90%': { y: -300 } }"
							class="pos:absolute r:0 b:-100px z:3 w:100% maw:pfs(150px,300px) m:auto"
							style="transform: translateY(-135.805px)"
						>
							<div class="w:100% pt:100%"></div>
							<div
								class="pos:absolute t:0 l:0 w:100% h:100% ov:hidden d:flex ai:center jc:center"
							>
								<?php echo wp_get_attachment_image($image2['id'], 'large', false, [
									"class" => "w:100% h:100% obf:cover obf:contain! w:100% h:100%"
								]); ?>
							</div>
						</v-parallax-scroll>
					<?php endif; ?>

					<div
						class="pos:absolute l:0 t:50% z:-1 trf:translateY(-50%) w:100%"
					>
						<v-parallax-scroll
							v-keyframes="{ '20%': { y: 100 }, '100%': { y: -100 } }"
							class="w:100%"
							style="transform: translateY(-20.2682px)"
						>
							<div
								class="pos:relative w:100% pt:100% bdrs:50%"
								style="
									background-color: <?php echo esc_attr($backgroundColor); ?>
									"
							>
								<div
									class="pos:absolute t:10% r:10% b:10% l:10% bdrs:50% bgc:color-primary op:0.1"
								></div>
								<div
									class="pos:absolute t:20% r:20% b:20% l:20% bdrs:50% bgc:color-primary op:0.1"
								></div>
							</div>
						</v-parallax-scroll>
					</div>
				</div>
			</div>
			<div
				class="col w:100%@+sm! flx:auto"
				style="
                width: 50%;
                margin-top: 80px;
                padding-left: 40px;
                padding-right: 40px;
              "
			>
				<div
					component="content"
					class="group* pos:relative ta:left@+sm!"
					style="border-radius: 0px; text-align: left"
				>
					<<?php echo esc_attr($headingTag); ?> class="c:color-gray9 trs:0.3s fw:600 fz:pfs(40px,80px) lh:1.2
					mb:0"><?php echo esc_html($heading); ?></<?php echo esc_attr($headingTag); ?>>
				<div class="fz:16px mt:20px">
					<p>
						<?php echo wp_kses_post($description); ?>
					</p>
				</div>
				<?php if (!empty($buttonUrl)) : ?>
					<a
						class="rs d:inline-block td:none lh:1.5 fz:15px ff:font-primary fw:500 trs:0.3s p:13px_20px bd:none bxsh:none o:none cur:pointer bgc:color-primary c:color-light bgc:color-gray9|h c:color-light|h bdrs:4px mt:40px"
						href="<?php echo esc_url($buttonUrl) ?>"
						target="<?php echo esc_attr($buttonTarget); ?>"
					>
						<span><?php echo esc_html($buttonText); ?></span>
						<?php if (!empty($iconValue)): ?>
							<span class="ml:10px" data-css="">
            <i class="<?php echo esc_attr($iconValue); ?>"></i>
          </span>
						<?php endif; ?>
					</a>
				<?php endif; ?>

				<?php if (!empty($image3)) : ?>
				<v-parallax-scroll
					v-keyframes="{ '10%': { y: 100 }, '90%': { y: -100 } }"
					class="pos:absolute r:0 t:-180px z:1 w:100% maw:pfs(100px,200px) m:auto"
					style="transform: translateY(-45.2682px)"
				>
					<div class="w:100% pt:100%"></div>
					<div
						class="pos:absolute t:0 l:0 w:100% h:100% ov:hidden d:flex ai:center jc:center pe:none"
					>
						<?php echo wp_get_attachment_image($image3['id'], 'large'); ?>
					</div>
					<?php endif; ?>
				</v-parallax-scroll>
			</div>
		</div>
	</div>
</v-parallax>
