<?php
// ====================================================================================
// SHORTCODE [chatadmin] – lista TODOS los hilos y permite al admin escribir en cada uno
// ====================================================================================
add_shortcode("chatadmin", function () {
    // Validar permisos de admin
    if (!current_user_can("manage_options")) {
        return "<div>Solo disponible para administradores.</div>";
    }

    global $wpdb;
    $table = $wpdb->prefix . "simple_chats";

    // obtener TODOS los hilos (pares únicos u_min-u_max) ordenados por el último mensaje
    $sql = "
        SELECT 
            chat_key,
            LEAST(sender_id, receiver_id) AS u_min,
            GREATEST(sender_id, receiver_id) AS u_max,
            MAX(created_at) AS last_at,
            COUNT(*) AS total
        FROM `$table`
        GROUP BY LEAST(sender_id, receiver_id), GREATEST(sender_id, receiver_id)
        ORDER BY last_at DESC
    ";
    $threads = $wpdb->get_results($sql, ARRAY_A);
    // filtrar hilos fantasma en PHP, cuando el admin interviene
    $threads = array_values(array_filter($threads, function($r){
        $u_min = intval($r["u_min"]);
        $u_max = intval($r["u_max"]);
        $expected = $u_min . "-" . $u_max;
        return isset($r["chat_key"]) && $r["chat_key"] == $expected;
    }));
    
    // Usuario admin actual (será el "from" al enviar)
    $admin_id = get_current_user_id();

    // Comenzar salida HTML
    $out  = '<div class="soc-chatlist-wrap" data-uid="' . $uid . '">';// misma clase envolvente que chatlist
    $out .= '<h1>All Chats (Admin moderation)</h1><br>';

    // Contenedor para la lista
    $out .= '<ul class="soc-chatlist">'; // misma clase de lista

    if (!empty($threads)) {
        foreach ($threads as $r) {
            // participantes del hilo
            $u_min = intval($r["u_min"]);
            $u_max = intval($r["u_max"]);
            $chat_key = esc_attr(soc_normalize_chat_key($u_min, $u_max)); // ej. "3-35"

            // nombres a mostrar
            $ua = get_user_by("id", $u_min);
            $ub = get_user_by("id", $u_max);
            $nameA = $ua ? $ua->display_name : "User " . $u_min;
            $nameB = $ub ? $ub->display_name : "User " . $u_max;

            // por defecto el admin enviará "to" al u_min (da igual para almacenamiento; el fetch usa chat_key)
            $default_to = $u_min;

            // item de la lista (igual que chatlist)
            $out .= '<li class="soc-thread-item">'
                 .  '<strong>' . esc_html($nameA) . ' ↔ ' . esc_html($nameB) . '</strong> IDs: ' . $chat_key 
                 .  '<span class="soc-last"> · ' . esc_html($r["last_at"]) . '</span>'
                 .  '<a href="#" class="soc-open-chat" data-chat-key="' . $chat_key . '">Read</a>';

            // contenedor del chat embebido (acordeón). 
            // Importante: NO usamos el shortcode [chat] aquí, porque necesitamos:
            //  - cargar por chat_key del par (u_min-u_max)
            //  - enviar como admin (from = $admin_id) sin alterar el chat_key
            $out .= '<div class="soc-chat-thread" style="display:none;">'
                .    '<div class="soc-chat-wrap soc-admin-wrap pair-' . $chat_key . '"'
                 .         ' data-chat-key="' . $chat_key . '"'
                 .         ' data-from="' . intval($admin_id) . '"'
                 .         ' data-to="' . intval($default_to) . '">'

                 // Encabezado
                 .        '<div class="soc-chat-header">'
                 .            '<strong>Chat:</strong> '
                 .            '<span class="soc-chat-parties">' . esc_html($nameA) . ' ↔ ' . esc_html($nameB) . '</span>'
                 .        '</div>'

                 // Contenedor de mensajes
                 .        '<div class="soc-chat-messages" style="border:1px solid #ddd; padding:10px; max-height:360px; overflow:auto; margin:8px 0;"></div>'

                 // Formulario de envío (admin)
                 .        '<form class="soc-chat-form" enctype="multipart/form-data" style="display:flex; gap:8px; align-items:flex-start; margin-top:8px;">'
                 .            '<textarea name="soc_message" rows="2" placeholder="Message..." style="flex:1; width:100%;"></textarea>'
                 .            '<input type="file" name="soc_attachment" accept="*/*" style="max-width:220px;">'
                 .            '<button type="submit">Send</button>'
                 .        '</form>'

                 .    '</div>' // .soc-admin-wrap
                 .  '</div>';  // .soc-chat-thread

            $out .= '</li>';
        }
    } else {
        $out .= '<li>No messages.</li>';
    }

    $out .= '</ul>';

    // script para acordeón (misma UX que chatlist) + lógica de chat por chat_key
    $out .= '<script>
jQuery(document).ready(function ($) {
    // Fallback de ajaxurl
    var ajaxurl = window.ajaxurl || "' . esc_url(admin_url('admin-ajax.php')) . '";

    // -----------------------------
    // Acordeón de la lista (igual que chatlist)
    // -----------------------------
    $(".soc-chatlist-wrap").on("click", ".soc-open-chat", function (e) {
        e.preventDefault();

        var $li = $(this).closest(".soc-thread-item");
        var $thread = $li.find(".soc-chat-thread");

        // Cerrar otros
        $li.siblings().find(".soc-chat-thread:visible").slideUp(200)
           .closest(".soc-thread-item").find(".soc-open-chat[aria-expanded=true]").attr("aria-expanded","false").text("Read");

        // Toggle actual
        if ($thread.is(":visible")) {
            $thread.slideUp(200);
            $(this).attr("aria-expanded","false").text("Read");
            // Parar polling si estaba corriendo
            var poll = $thread.data("poll");
            if (poll) { clearInterval(poll); $thread.removeData("poll"); }
        } else {
            $thread.slideDown(200);
            $(this).attr("aria-expanded","true").text("Close");

            // Al abrir: carga inicial + arrancar polling para este hilo
            var $wrap = $thread.find(".soc-admin-wrap");
            loadMessagesFor($wrap, true);
            var pollId = setInterval(function(){ loadMessagesFor($wrap, false); }, 5000);
            $thread.data("poll", pollId);
        }
    });

    // -----------------------------
    // Render de un hilo (reutiliza tus clases .soc-from / .soc-to)
    // -----------------------------
    function hasTextContent(html){
        if (html == null) return false;
        var txt = $("<div>").html(html).text();
        txt = $.trim(txt.replace(/\\u00A0/g, " "));
        return txt.length > 0;
    }

    function renderMsg(row, fromId) {
        // Etiqueta del emisor (admin destacado si aplica)
        var label = row.sender_display;
        var isadmin = "";
        if (row.sender_is_admin == 1) {
            label = "<span style=\\"color: red; font-size:150%;\\">Website admin</span>";
            isadmin = " isadmin";
        }

        // Lado
        var isFrom = (row.sender_id == fromId);
        var sideClass = isFrom ? "soc-from" : "soc-to";
        
        // sacar u_min y u_max desde chat_key "min-max" para clases de css
        var umin = null, umax = null;
        if (row.chat_key && row.chat_key.indexOf("-") > -1) {
            var parts = row.chat_key.split("-");
            umin = parseInt(parts[0], 10);
            umax = parseInt(parts[1], 10);
        }
        var senderClass = "";
        if (umin != null && umax != null) {
            if (row.sender_id == umin) { senderClass = " least"; }
            else if (row.sender_id == umax) { senderClass = " greatest"; }
        }
    
        // Burbuja de texto (solo si hay contenido real)
        var msgHtml = "";
        if (hasTextContent(row.message)) {
            msgHtml = \'<div class="soc-text">\' + row.message + \'</div>\';
        }

        // Adjunto como burbuja aparte
        var fileHtml = "";
        if (row.attachment && row.attachment != "") {
            var url = row.attachment_download || row.attachment_url || row.attachment;
            var fileName = url.split("/").pop();
            fileHtml = \'<div class="soc-file"><a href="\' + url + \'" download target="_self">\' + fileName + \'</a></div>\';
        }

        return ""
            + \'<div class="soc-msg \' + sideClass + senderClass + isadmin + \'">\'
            +   \'<div class="soc-meta"><strong>\' + label + \'</strong> · \' + row.created_at + \'</div>\'
            +    msgHtml
            +    fileHtml
            + \'</div>\';
    }

    // -----------------------------
    // Carga incremental + scroll por contenedor
    // -----------------------------
    function isNearBottom($el) {
        return ($el.scrollTop() + $el.innerHeight()) >= ($el[0].scrollHeight - 10);
    }

    function loadMessagesFor($wrap, forceScroll){
        // Estados por wrap (para convivir varios abiertos)
        var isLoading = $wrap.data("isLoading") === true;
        if (isLoading) return;
        $wrap.data("isLoading", true);

        var chatKey = $wrap.data("chat-key");
        var fromId  = parseInt($wrap.data("from"), 10);
        var $msgs   = $wrap.find(".soc-chat-messages");

        var lastId  = parseInt($wrap.data("lastId") || 0, 10);
        var wasAtBottom = isNearBottom($msgs);

        $.post(ajaxurl, { action:"soc_fetch_messages", chat_key: chatKey }, function(resp){
            if (resp && resp.success == true) {
                var list = resp.data || [];
                var newCount = 0;
                var localMax = lastId;

                for (var i=0; i<list.length; i++){
                    var row = list[i];
                    if (row.id > lastId) {
                        $msgs.append( renderMsg(row, fromId) );
                        newCount++;
                    }
                    if (row.id > localMax) localMax = row.id;
                }

                $wrap.data("lastId", localMax);

                if (forceScroll || (wasAtBottom && newCount > 0)) {
                    $msgs.scrollTop($msgs[0].scrollHeight);
                }
            }
        }, "json").always(function(){
            $wrap.data("isLoading", false);
        });
    }

    // -----------------------------
    // Envío de mensaje (admin) por contenedor
    // -----------------------------
    $(".soc-chatlist-wrap").on("submit", ".soc-admin-wrap .soc-chat-form", function(e){
        e.preventDefault();

        var $wrap  = $(this).closest(".soc-admin-wrap");
        var chatKey = $wrap.data("chat-key");
        var fromId  = parseInt($wrap.data("from"), 10); // admin actual
        var toId    = parseInt($wrap.data("to"), 10);   // por defecto u_min

        var $form = $(this);
        var $ta   = $form.find("textarea[name=\'soc_message\']");
        var msg   = $ta.val();

        var fileInput = $form.find("input[name=\'soc_attachment\']")[0];
        var hasFile   = (fileInput && fileInput.files && fileInput.files.length > 0);

        // Validación: permitir texto o adjunto (bloquear si ambos vacíos)
        if ($.trim(msg) === "" && !hasFile) {
            console.log("No puedes enviar un mensaje vacío sin adjunto");
            return;
        }

        var fd = new FormData();
        fd.append("action", "soc_send_message");
        fd.append("chat_key", chatKey); // clave del par (u_min-u_max)
        fd.append("from", fromId);      // admin como emisor
        fd.append("to", toId);          // receptor (uno del par; el fetch no lo usa)
        fd.append("message", msg);

        if (hasFile) {
            fd.append("attachment", fileInput.files[0]);
        }

        $.ajax({
            url: ajaxurl,
            method: "POST",
            data: fd,
            contentType: false,
            processData: false,
            dataType: "json",
            success: function(resp){
                if (resp && resp.success == true) {
                    $ta.val("");
                    if (fileInput) fileInput.value = "";
                    loadMessagesFor($wrap, true); // forzar scroll tras enviar
                }
            }
        });
    });
});
</script>';

    $out .= "</div>"; // cierre soc-chatlist-wrap

    return $out;
});
