<?php
/*
Plugin Name: Admin Restrictor
Description: Oculta y restringe menús del backend para ciertos administradoreso usuarios por id, se puede tunear desde el backend. Tambiénincluye CSS para el backend. El plugin se oculta de esta lista al activarse.
Author: alexcd2000
Version: 3.0
*/

// Defaults de la aplicación al activar
add_action('admin_init', function () {
    if (get_option('admin_restrictor_config') === false && is_user_logged_in()) {
        $current_user_id = get_current_user_id();
        $default_config = [
            'allowed_ids' => [$current_user_id],
            'block_full' => [
                "Admin Restrictor", "all-in-one", "CSS & JavaScript", "WPIDE", "Wordfence", "WP Mail", "CPT UI",
                "Custom Fields", "Settings"
            ],
            'block_partial' => [
                "plugin file editor","Settings", "Custom ", "Role", "Tools",
                "getting started", "Get help", "apps", "system info"
            ],
            'exceptions' => [
                2 => [
                    "Tools", "Comments"
                ],
                3 => [
                    "Other entries, that you want this user to actually have access"
                ]
            ],
            'global_css' => 'tr[data-slug=admin-restrictor], #wp-admin-bar-new-content, #wp-admin-bar-comments, #welcome-panel, .index-php #dashboard-widgets-wrap { display: none !important; }',
            'restricted_css' => '.edit_with_elementor, #menu-dashboard { display: none !important; }'
        ];
        add_option('admin_restrictor_config', $default_config);
    }
});

// Crea página Backend
add_action('admin_menu', 'admin_restrictor_menu');
function admin_restrictor_menu() {
    add_menu_page(
        'Admin Restrictor',
        'Admin Restrictor',
        'manage_options',
        'admin-restrictor',
        'admin_restrictor_page',
        'dashicons-shield',
        80
    );
}

// Formulario para editar config
function admin_restrictor_page() {
    $config = get_option('admin_restrictor_config', []);

    $allowed_ids = implode(',', $config['allowed_ids'] ?? [26]);
    $block_full = implode("\n", $config['block_full'] ?? []);
    $block_partial = implode("\n", $config['block_partial'] ?? []);
    $exceptions = $config['exceptions'] ?? [];
    $restricted_css = $config['restricted_css'] ?? '';
    
    ?>
    <div class="wrap">
        <h1>Admin Restrictor Settings</h1>
        <form method="post" action="">
            <?php wp_nonce_field('admin_restrictor_save'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row">Global Backend CSS - Includes hidding this plugin from the list already "tr[data-slug=admin-restrictor]"</th>
                    <td><textarea name="global_css" style="width: 100%;" rows="3"><?php echo esc_textarea($config['global_css'] ?? ''); ?></textarea></td>
                </tr>
                <tr>
                    <th scope="row">Whitelisted User IDs Restriction- By default who activated the plugin AKA You</th>
                    <td><input type="text" name="allowed_ids" value="<?php echo esc_attr($allowed_ids); ?>" style="width: 100%;"/></td>
                </tr>
                <tr>
                    <th scope="row">Restricted Users CSS (only for non allowed_ids)</th>
                    <td><textarea name="restricted_css" style="width: 100%;" rows="3"><?php echo esc_textarea($restricted_css); ?></textarea></td>
                </tr>
                <tr>
                    <th scope="row">Blocked Menus - Added "Admin Restrictor" so other users dont see this... (blocking "tools" blocks wordfence for some reason, beware)</th>
                    <td><textarea name="block_full" style="width: 100%;" rows="5"><?php echo esc_textarea($block_full); ?></textarea></td>
                </tr>
                <tr>
                    <th scope="row">Blocked Submenus</th>
                    <td><textarea name="block_partial" style="width: 100%;" rows="5"><?php echo esc_textarea($block_partial); ?></textarea></td>
                </tr>
                <tr>
                    <th scope="row">Exceptions per user (JSON) - Write what exceptions for what user, from Blocked Menus only that user will have access</th>
                    <td><textarea name="exceptions" style="width: 100%;" rows="8"><?php echo esc_textarea(json_encode($exceptions, JSON_PRETTY_PRINT)); ?></textarea></td>
                </tr>
            </table>
            <p><input type="submit" class="button button-primary" value="Guardar cambios"/></p>
        </form>
    </div>
    <?php
}
add_action('admin_init', function () {
    if (isset($_POST['allowed_ids']) && check_admin_referer('admin_restrictor_save')) {
        $data = [
            'allowed_ids' => array_filter(array_map('intval', explode(',', $_POST['allowed_ids']))),
            'block_full' => array_filter(array_map('trim', explode("\n", $_POST['block_full']))),
            'block_partial' => array_filter(array_map('trim', explode("\n", $_POST['block_partial']))),
            'exceptions' => json_decode(stripslashes($_POST['exceptions']), true) ?? [],
            'global_css' => trim($_POST['global_css'] ?? ''),
            'restricted_css' => trim($_POST['restricted_css'] ?? '')
        ];
        update_option('admin_restrictor_config', $data);
        echo '<div class="notice notice-success"><p>Config updated.</p></div>';
    }
});

// Aplicar la logica del restringir otros admins u usuarios con CSS y JS
add_action('admin_enqueue_scripts', function () {

    // CONFIG desde wp_options
    $config = get_option('admin_restrictor_config', []);
    $allowed_ids   = $config['allowed_ids'] ?? [26];
    $block_full    = $config['block_full'] ?? [];
    $block_partial = $config['block_partial'] ?? [];
    $exceptions    = $config['exceptions'] ?? [];
    $restricted_css = $config['restricted_css'] ?? '';

    if (!empty($config['global_css'])) {
    echo "<style id='simply-hide'>{$config['global_css']}</style>";
    }//CSS Global

    $current_user_id = get_current_user_id();
    // Si NO está en allowed_ids => aplicar CSS extra
    if (!in_array($current_user_id, $allowed_ids) && !empty($restricted_css)) {
        echo "<style id='restricted-users-css'>{$restricted_css}</style>";
    }
    //Si a algun usuario hay que darle algun acceso de mas:
    if (isset($exceptions[$current_user_id]) && is_array($exceptions[$current_user_id])) {
        $excepciones = array_map('strtolower', $exceptions[$current_user_id]);
        $block_full = array_filter($block_full, function ($item) use ($excepciones) {
            return !in_array(strtolower($item), $excepciones);
        });
        $block_full = array_values($block_full);
    }

    // Verifica si es un usuario libre
    //if (!current_user_can('administrator') || in_array(get_current_user_id(), $allowed_ids)) return;
    if (in_array(get_current_user_id(), $allowed_ids)) return;

    // Inyecta estilo directamente para evitar glitch visual
    add_action('admin_head', function () {
        echo "<style id='acd-hide-menu'>body { display: none !important; }</style>";
    });
	
	// Prepara datos para JS
    $block_full_json    = wp_json_encode($block_full);
    $block_partial_json = wp_json_encode($block_partial);
    $dashboard_url      = admin_url();

    // Script inline
    $inline_js = <<<JS
jQuery(document).ready(function ($) {

    var blockFull = $block_full_json;
    var blockPartial = $block_partial_json;
    var blockedUrls = [];

    // Elimina menús principales completos
    $("#adminmenu > li").each(function () {
        var \$li = $(this);
        var text = \$li.text().trim().toLowerCase();

        var match = blockFull.some(function (w) {
            return text.includes(w.toLowerCase());
        });

        if (match) {
            \$li.find("a").each(function () {
                blockedUrls.push($(this).attr("href"));
            });
            \$li.remove();
        }
    });

    // Elimina submenús (deja los padres)
    $("#adminmenu li ul li").each(function () {
        var \$li = $(this);
        var text = \$li.text().trim().toLowerCase();

        var match = blockPartial.some(function (w) {
            return text.includes(w.toLowerCase());
        });

        if (match) {
            \$li.find("a").each(function () {
                blockedUrls.push($(this).attr("href"));
            });
            \$li.remove();
        }
    });

    // Redirección si ya está en una URL bloqueada
	var redirige = false;
    blockedUrls.forEach(function (url) {
        if (url && window.location.href.includes(url)) {
            window.location.href = "$dashboard_url";
			redirige = true;
        }
    });

    // Muestra menú y el body ya que acabo si es que no redirige
	if( !redirige ){
	    $("#acd-hide-menu").remove();
	}
});
JS;

    // Encola inline JS
    wp_add_inline_script('jquery', $inline_js);
});

