// App.jsx — App mínima con WebView + botón Home + inyección remota de CSS/JS
import React, { useRef, useState } from "react";
import { View, TouchableOpacity, StyleSheet } from "react-native";
import { WebView } from "react-native-webview";

// ===============================
// 1) Variables configurables
// ===============================
const HOME_URL = "https://alexcd2000.com/tools/App-React-Tools/";

const CUSTOM_CSS_URL = "https://alexcd2000.com/tools/App-React-Tools/custom.css?v=" + Date.now();

const CUSTOM_JQUERY_URL  = "https://alexcd2000.com/tools/App-React-Tools/jquery.min.js";
const CUSTOM_JS_URL  = "https://alexcd2000.com/tools/App-React-Tools/custom.js?v=" + Date.now();

// ===============================
// 2) Inyección
// ===============================
// agregamos un "bootstrap" que se ejecuta ANTES de que cargue el contenido.
// Prepara un listener para inyectar justo en DOMContentLoaded y añade trazas.
const BOOTSTRAP_INJECTION = `
  (function(){
    try{
      // traquear que el bootstrap corrió
      if(window.ReactNativeWebView){ window.ReactNativeWebView.postMessage("bootstrap:ready"); }

      var inject = function(){
        try{
          var head=document.head||document.documentElement;
          var body=document.body||document.documentElement;

          // Limpiar inyecciones previas
          ["__rn_custom_css_url","__rn_custom_jquery_url","__rn_custom_js_url"].forEach(function(id){
            var el=document.getElementById(id); if(el && el.parentNode) el.parentNode.removeChild(el);
          });

          // CSS remoto
          var link=document.createElement("link");
          link.id="__rn_custom_css_url";
          link.rel="stylesheet";
          link.href=${JSON.stringify(CUSTOM_CSS_URL)};
          head.appendChild(link);

          // jQuery primero
          var jq=document.createElement("script");
          jq.id="__rn_custom_jquery_url";
          jq.src=${JSON.stringify(CUSTOM_JQUERY_URL)};
          jq.onload=function(){
            // JS propio después de jQuery
            var sc=document.createElement("script");
            sc.id="__rn_custom_js_url";
            sc.src=${JSON.stringify(CUSTOM_JS_URL)};
            (body||head).appendChild(sc);

            // traza para confirmar que se cargó jQuery y se inyectó tu JS
            if(window.ReactNativeWebView){
              window.ReactNativeWebView.postMessage("inject:jquery+customjs");
            }
          };
          (body||head).appendChild(jq);

          // traza para confirmar que se metió el CSS
          if(window.ReactNativeWebView){ window.ReactNativeWebView.postMessage("inject:css"); }
        }catch(e){
          if(window.ReactNativeWebView){ window.ReactNativeWebView.postMessage("inject:error"); }
        }
      };

      // inyectar tan pronto haya DOM, incluso en navegaciones rápidas.
      if(document.readyState === "loading"){
        document.addEventListener("DOMContentLoaded", inject, { once:true });
      } else {
        inject();
      }
    }catch(e){
      if(window.ReactNativeWebView){ window.ReactNativeWebView.postMessage("bootstrap:error"); }
    }
    true;
  })();
`;

const DIRECT_INJECTION = `
  (function(){
    try {
      // --- Forzar meta viewport ---
      var head = document.head || document.getElementsByTagName('head')[0];
      var vp = document.querySelector('meta[name="viewport"]');
      var content = "width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no";
      if (!vp) {
        vp = document.createElement("meta");
        vp.name = "viewport";
        vp.content = content;
        head.appendChild(vp);
      } else {
        vp.setAttribute("content", content);
      }

    } catch(e) {
      if(window.ReactNativeWebView){ window.ReactNativeWebView.postMessage("inject:error:"+e.message); }
    }
    true;
  })();
`;



// ===============================
// 3) Componente principal
// ===============================
export default function App(){
  const webRef = useRef(null);
  const [reloadKey,setReloadKey] = useState(0);

  const goHome = () => {
    if(webRef.current){
      const js='window.location.replace('+JSON.stringify(HOME_URL)+'); true;';
      webRef.current.injectJavaScript(js);
    } else {
      setReloadKey(k=>k+1);
    }
  };

  return (
    <View style={styles.container}>
      <WebView
        key={reloadKey}
        ref={webRef}
        source={{ uri: HOME_URL }}
        cacheEnabled={false}  // desactiva caché de recursos
        originWhitelist={["*"]}
        javaScriptEnabled
        domStorageEnabled
        setSupportMultipleWindows={false}

        onMessage={(e)=>{ console.log("WV:", e.nativeEvent.data); }}  // Log de eventos de inyección

        // asegurar cookies compartidas/persistentes
        sharedCookiesEnabled={true}           // iOS/Android: comparte con CookieManager, ayuda a persistir
        thirdPartyCookiesEnabled={true}       // Android: SSO / providers de login en dominios terceros

        // no usar modo incógnito
        incognito={false}                     // asegura que NO se borren cookies/cache al cerrar

        // mantener cache habilitado (por si tu login la usa)
        cacheEnabled={true}                   // true por defecto, lo dejamos explícito
          
        // inyectar ANTES de que cargue el contenido de cada navegación
        injectedJavaScriptBeforeContentLoaded={BOOTSTRAP_INJECTION}          
        injectedJavaScriptBeforeContentLoadedForMainFrameOnly={false}        

        // inyectar también al final de la carga
        injectedJavaScript={DIRECT_INJECTION}                                 
        injectedJavaScriptForMainFrameOnly={false}                            

        // recibir trazas desde la página
        onMessage={(e)=>{ console.log("WV:", e.nativeEvent.data); }}          

        // ya no necesitamos reinyectar aquí, el injected* lo hace por nosotros
        onLoadEnd={undefined}                                                 
        onNavigationStateChange={undefined}                                   
      />

      <TouchableOpacity onPress={goHome} activeOpacity={0.85} style={styles.fab}>
        <View style={styles.homeIcon}><View style={styles.roof}/><View style={styles.base}/></View>
      </TouchableOpacity>
    </View>
  );
}

// ===============================
// 4) Estilos
// ===============================
const styles=StyleSheet.create({
  container:{flex:1},
  fab:{position:"absolute",left:16,bottom:16,width:44,height:44,borderRadius:22,
       backgroundColor:"rgba(0,0,0,0.75)",alignItems:"center",justifyContent:"center",elevation:6},
  homeIcon:{width:18,height:18,alignItems:"center"},
  roof:{width:0,height:0,borderLeftWidth:9,borderRightWidth:9,borderBottomWidth:8,
        borderLeftColor:"transparent",borderRightColor:"transparent",
        borderBottomColor:"#ffffff",marginBottom:2},
  base:{width:16,height:8,backgroundColor:"#ffffff"}
});
